// Created by Newton Book Maker 1.1
//  Note: This file may contain needed resources !! 
// Document
book := {
	version: 2,
	isbn: "ISBN6:03:19 AM",
	help: TRUE,
	contents: Array(50, NIL),
	styles: [],
	browsers: [], templates: [], rendering: []};
//output.book := book;
//output.help := TRUE;

// Shared Map Functions
func MakePage(aTemplate)
	{template: aTemplate, blocks: []};
func MakeBlock(aBounds, anItem)
	{bounds: aBounds, item: anItem};

// Shared Scripts
gotoDestScript := func() begin
	if (curRendering = 0) then :TurnToPage(destPage);
	else :TurnToPage(:FindPageByContent(kioskDest, 0, NIL));
end;

// Text Styles
s0 := {
	family: 'Geneva,
	face: 0,
	size: 9};
AddArraySlot(book.styles, s0);

s1 := {
	family: 'espy /* Monaco */,
	face: 0,
	size: 10};
AddArraySlot(book.styles, s1);

s2 := {
	family: 'Espy,
	face: 1,
	size: 14};
AddArraySlot(book.styles, s2);

s3 := {
	family: 'Espy,
	face: 1,
	size: 12};
AddArraySlot(book.styles, s3);

s4 := {
	family: 'Espy,
	face: 0,
	size: 10};
AddArraySlot(book.styles, s4);

s5 := {
	family: 'Espy,
	face: 1,
	size: 10};
AddArraySlot(book.styles, s5);

s6 := {
	family: 'espy /* Monaco */,
	face: 1,
	size: 10};
AddArraySlot(book.styles, s6);


// Contents
c1 := {
	data: "Use EnRoute i-net
",
	layout: 2048
};
book.contents[0] := c1;

c2 := {
	data: "Exchange electronic mail",
	viewFont: s5,
	layout: 32
};
book.contents[1] := c2;

c3 := {
	data: "This online help book describes how to call an Internet Server Provider (ISP) and exchange electronic mail with other Internet users via EnRoute i-net. Please refer to the printed manual for more detailed information.

You can use EnRoute i-net to send and receive text messages, packages, and items from the Notepad, Date Book, Name File, NewtWorks and other applications.
",
	styles: [374, s4, 1, s1]
};
book.contents[2] := c3;

c4 := {
	data: "Send Messages",
	viewFont: s5,
	layout: 32
};
book.contents[3] := c4;

c5 := {
	data: "1. Select the item you wish to send.
2. Tap the Routing button.
3. In the list that appears, tap Mail.
4. In the slip that appears, enter the appropriate information.
5. Tap Mail, then Tap Connect.

A slip appears showing you the status of your connection.

You can send messages and packages via EnRoute i-net.
",
	viewFont: s4
};
book.contents[4] := c5;

c6 := {
	data: "Receive Messages",
	styles: [16, s5, 1, s4],
	layout: 32
};
book.contents[5] := c6;

c7 := {
	data: "1. Tap the InOut Box.
2. Tap the In Box button.
3. Tap Receive
4. In the list that appears, tap i-net Mail.
5. In the slip that appears, enter the appropriate information.
6. Tap Connect.

A slip appears showing connection status.

You can receive messages and packages via EnRoute i-net.
",
	styles: [48, s4, 140, s1, 101, s4, 1, s1]
};
book.contents[6] := c7;

c8 := {
	data: "View Received Messages",
	styles: [22, s5, 1, s4],
	layout: 32
};
book.contents[7] := c8;

c9 := {
	data: "1. Tap the InOut Box.
2. Tap the In Box button.
3. Tap the item you want to view. It will appear on the screen.

 Notepad, Date Book and Name File items which are automatically put away must be viewed by going to the appropriate location.
",
	viewFont: s4
};
book.contents[8] := c9;

c10 := {
	data: "Set EnRoute i-net Preferences
",
	layout: 2048
};
book.contents[9] := c10;

c11 := {
	data: "Use the \"After sending\" Picker",
	viewFont: s5,
	layout: 32
};
book.contents[10] := c11;

c12 := {
	data: "1. Tap \u201c" & "After sending\u201d" & "
2. In the list that appears, select \u201c" & "Disconnect\u201d" & " or \u201c" & "Receive mail\u201d" & ".

\u201c" & "Disconnect\u201d" & " immediately disconnects you from the mail server, even if there is mail in your account.

\u201c" & "Receive mail\u201d" & " will download your mail.
",
	styles: [235, s4, 1, s1]
};
book.contents[11] := c12;

c13 := {
	data: "Use the \"After receiving\" Picker",
	viewFont: s5,
	layout: 32
};
book.contents[12] := c13;

c14 := {
	data: "1. Tap \u201c" & "After receiving\u201d" & "
2. In the list that appears, tap \u201c" & "Disconnect\u201d" & " or \u201c" & "Send mail\u201d" & ".

\u201c" & "Disconnect\u201d" & " immediately disconnects you from the mail server, even if you have mail to send.

\u201c" & "Send mail\u201d" & " will send your mail to the Internet.
",
	styles: [232, s4, 1, s1]
};
book.contents[13] := c14;

c15 := {
	data: "Use the \"Download the first\" Picker",
	viewFont: s5,
	layout: 32
};
book.contents[14] := c15;

c16 := {
	data: "1. Tap \u201c" & "Download the first\u201d" & "
2. In the list that appears, select the maximum number of items for EnRoute to download during a single session.
",
	styles: [141, s4, 1, s1]
};
book.contents[15] := c16;

c17 := {
	data: "Specify Read, Unread or All Mail",
	viewFont: s6,
	layout: 32
};
book.contents[16] := c17;

c18 := {
	data: "1. Tap \u201c" & "Download the first\u201d" & "
2. In the lower portion of the list that appears, select \"New Only\", \"Read Only\" or \"Any Items\" (Both read and unread mail)
",
	styles: [152, s4, 1, s1]
};
book.contents[17] := c18;

c19 := {
	data: "Use the \"Leave on server\" Checkbox",
	viewFont: s5,
	layout: 32
};
book.contents[18] := c19;

c20 := {
	data: "Check \u201c" & "Leave on server\u201d" & " to prevent read messages from being automatically deleted from your internet email account.

To prevent the loss of messages, if any read message includes content which cannot be received, EnRoute i-net will NOT automatically delete the message from the server.
",
	viewFont: s4
};
book.contents[19] := c20;

c21 := {
	data: "Use the \"When mailing\" Picker",
	viewFont: s5,
	layout: 32
};
book.contents[20] := c21;

c22 := {
	data: "1. Tap \u201c" & "When mailing\u201d" & "
2. In the list that appears, select \u201c" & "Send now\u201d" & ", \u201c" & "Send later\u201d" & " or \u201c" & "Specify when\u201d" & ".

\u201c" & "Send now\u201d" & " mails the items right away. 

\u201c" & "Send later\u201d" & " places an item in the Out Box until you mail it.

\u201c" & "Specify when\u201d" & " gives you a choice of \u201c" & "Now\u201d" & " or \u201c" & "Later\u201d" & " to select from the Routing slip.
",
	styles: [294, s4, 1, s1]
};
book.contents[21] := c22;

c23 := {
	data: "Use the \"After sending mail\" Picker",
	viewFont: s5,
	layout: 32
};
book.contents[22] := c23;

c24 := {
	data: "1. Tap \u201c" & "After sending mail\u201d" & "
2. In the list that appears, choose whether to file, log, or delete items after sending them.
",
	styles: [122, s4, 1, s1]
};
book.contents[23] := c24;

c25 := {
	data: "Use the \"File read mail in\" Picker",
	viewFont: s5,
	layout: 32
};
book.contents[24] := c25;

c26 := {
	data: "1. Tap \u201c" & "File read mail in\u201d" & "
2. In the slip that appears, tap the name of the folder to file read items in.
3. Tap Set.
",
	styles: [118, s4, 1, s1]
};
book.contents[25] := c26;

c27 := {
	data: "Schedule Automatic sessions",
	viewFont: s5,
	layout: 32
};
book.contents[26] := c27;

c28 := {
	data: "1. Tap the \u201c" & "Schedule\u201d" & " button.
2. In the slip that appears, enter information regarding when you want EnRoute i-net to automatically send and receive messages.
",
	styles: [159, s4, 1, s1]
};
book.contents[27] := c28;

c29 := {
	data: "Use the \"Info\" Picker",
	viewFont: s5,
	layout: 32
};
book.contents[28] := c29;

c30 := {
	data: "The \"i\" button in the lower left hand corner of the preferences slip provides access to the \"About\" information, this Help information, and the settings for many of the EnRoute i-net plug-in modules.

",
	styles: [200, s4, 1, s5, 1, s1]
};
book.contents[29] := c30;

c31 := {
	data: "Use EnRoute Plug-in Software
",
	layout: 2048
};
book.contents[30] := c31;

c32 := {
	data: "Access Plug-ins",
	styles: [15, s5, 1, s4],
	layout: 32
};
book.contents[31] := c32;

c33 := {
	data: "Plug-in modules are simple focused additions to EnRoute i-net.

The settings for most plug-in software are accessed by tapping on the \u201c" & "i\u201d" & " button found in the lower left hand corner of the EnRoute i-net preferences slip and then tapping on the plug-in name.
",
	styles: [257, s4, 1, s1]
};
book.contents[32] := c33;

c34 := {
	data: "Use the POP List Manager",
	styles: [24, s5, 1, s4],
	layout: 32
};
book.contents[33] := c34;

c35 := {
	data: "The POP List Manager allows you to manage your email account using EnRoute i-net. The POP List Manager will allow you to re-read or delete a message from your POP server. The list that is presented reflects what your account contained on the server after the LAST time you connected.

Using the check-boxes you can select email messages that are to be read again and/or deleted the next time you connect using EnRoute i-net.
",
	styles: [425, s4, 1, s1]
};
book.contents[34] := c35;

c36 := {
	data: "Use the Size Filter",
	styles: [19, s5, 1, s4],
	layout: 32
};
book.contents[35] := c36;

c37 := {
	data: "1. Enable or disable the Size Filter by checking or unchecking the \"Skip messages\" checkbox.
2. Use the \"Larger than\" picker to set a maximum message size.

The message Size Filter allows you to select the maximum size of messages that EnRoute i-net will receive automatically.
",
	styles: [93, s4, 63, s1, 123, s4]
};
book.contents[36] := c37;

c38 := {
	data: "Use the Message Signature plug-in",
	styles: [33, s5, 1, s4],
	layout: 32
};
book.contents[37] := c38;

c39 := {
	data: "The Signature plug-in allows you to select whether EnRoute i-net will append text to the bottom of each email message sent.

You also configure the appended text using this plug-in. 

The most popular use of the Signature plug-in is to personalize all email messages being sent.
",
	styles: [279, s4, 1, s1]
};
book.contents[38] := c39;

c40 := {
	data: "Use the Rules Filter",
	styles: [20, s5, 1, s4],
	layout: 32
};
book.contents[39] := c40;

c41 := {
	data: "This filter permits you to accept and reject email messages based on criteria which are set up using the Rule Editor.

The Rule Editor application supplied with EnRoute i-net is filed under Setup in the Extras Drawer.

Once the criteria have been defined, you can save and file them for future use. This filter allows you to select the Rule Set to use and to enable or disable the filter.
",
	styles: [389, s4, 1, s1]
};
book.contents[40] := c41;

c42 := {
	data: "Use the Text Encoding plug-in",
	styles: [29, s5, 1, s4],
	layout: 32
};
book.contents[41] := c42;

c43 := {
	data: "This plug-in allows you to select between \"7 bit ASCII with substitute option characters\" and \"Quoted Printable MIME Text\".

This means that a message can be stripped to its simplest form for transmission to older ASCII text-only email clients, or can be sent using the more modern ISO international character set known as Quoted Printable.
",
	viewFont: s4
};
book.contents[42] := c43;

c44 := {
	data: "Learn some Tips and Techniques
",
	layout: 2048
};
book.contents[43] := c44;

c45 := {
	data: "Solve problems",
	styles: [14, s5, 1, s4],
	layout: 32
};
book.contents[44] := c45;

c46 := {
	data: "EnRoute i-net will provide you with reliable Internet messaging. As the performance and reliability of the Internet can at times be unpredictable, the following tips and techniques should help.

As a rule of thumb, should something unexpected occur, give the Internet or your ISP time to correct the problem and try again.
",
	styles: [323, s4, 1, s1]
};
book.contents[45] := c46;

c47 := {
	data: "Learn about Memory",
	styles: [18, s5, 1, s4],
	layout: 32
};
book.contents[46] := c47;

c48 := {
	data: "Text-only messages require very little memory to send or receive. To process enclosures, however, EnRoute i-net requires approximately a 4 to 1 ratio of available memory to item size.

For example, to send someone a Package which is 390K, you will require at least 1.5M of free space.

During reception of a 390K package, 1.5M will also be required, but once received, it will only occupy the original 390K.
",
	styles: [408, s4, 1, s1]
};
book.contents[47] := c48;

c49 := {
	data: "Change the NIE Session Length",
	styles: [29, s5, 1, s4],
	layout: 32
};
book.contents[48] := c49;

c50 := {
	data: "NIE can be configured to stay \"online\" after an EnRoute i-net session is finished.
This can be very handy should you wish to reply to your email without having to reconnect to the Internet.

To configure NIE to stay online, open the Prefs for the Internet Setup application and tap Hang up. Select the amount of idle time before NIE disconnects.

To manually disconnect NIE, tap the blinking star at the top of the screen.
",
	viewFont: s4
};
book.contents[49] := c50;


// Kiosk (menu page) references

// Page Templates
NBMDefault := {
	nColumns: 1,
	column: [{
	width: 12,
	type: 0}]
};
AddArraySlot(book.templates, NBMDefault);

// Bounds List
bnd1 := [0,0,206,14];
bnd2 := [0,14,206,214];
bnd3 := [0,0,206,28];
bnd4 := [0,28,206,214];
bnd5 := [0,0,206,26];
bnd6 := [0,26,206,214];
bnd7 := [0,14,206,210];

// Pages
pageList := {pageSize: {left: 0, top: 0, right: 206, bottom: 214}, pages: []};

// Page 1
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c2));
AddArraySlot(page.blocks, MakeBlock(bnd2, c3));
AddArraySlot(pageList.pages, page);

// Page 2
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c4));
AddArraySlot(page.blocks, MakeBlock(bnd2, c5));
AddArraySlot(pageList.pages, page);

// Page 3
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c6));
AddArraySlot(page.blocks, MakeBlock(bnd2, c7));
AddArraySlot(pageList.pages, page);

// Page 4
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c8));
AddArraySlot(page.blocks, MakeBlock(bnd2, c9));
AddArraySlot(pageList.pages, page);

// Page 5
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c11));
AddArraySlot(page.blocks, MakeBlock(bnd2, c12));
AddArraySlot(pageList.pages, page);

// Page 6
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c13));
AddArraySlot(page.blocks, MakeBlock(bnd2, c14));
AddArraySlot(pageList.pages, page);

// Page 7
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd3, c15));
AddArraySlot(page.blocks, MakeBlock(bnd4, c16));
AddArraySlot(pageList.pages, page);

// Page 8
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd5, c17));
AddArraySlot(page.blocks, MakeBlock(bnd6, c18));
AddArraySlot(pageList.pages, page);

// Page 9
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd3, c19));
AddArraySlot(page.blocks, MakeBlock(bnd4, c20));
AddArraySlot(pageList.pages, page);

// Page 10
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c21));
AddArraySlot(page.blocks, MakeBlock(bnd2, c22));
AddArraySlot(pageList.pages, page);

// Page 11
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c23));
AddArraySlot(page.blocks, MakeBlock(bnd2, c24));
AddArraySlot(pageList.pages, page);

// Page 12
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c25));
AddArraySlot(page.blocks, MakeBlock(bnd2, c26));
AddArraySlot(pageList.pages, page);

// Page 13
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c27));
AddArraySlot(page.blocks, MakeBlock(bnd2, c28));
AddArraySlot(pageList.pages, page);

// Page 14
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c29));
AddArraySlot(page.blocks, MakeBlock(bnd2, c30));
AddArraySlot(pageList.pages, page);

// Page 15
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c32));
AddArraySlot(page.blocks, MakeBlock(bnd2, c33));
AddArraySlot(pageList.pages, page);

// Page 16
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c34));
AddArraySlot(page.blocks, MakeBlock(bnd2, c35));
AddArraySlot(pageList.pages, page);

// Page 17
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c36));
AddArraySlot(page.blocks, MakeBlock(bnd2, c37));
AddArraySlot(pageList.pages, page);

// Page 18
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c38));
AddArraySlot(page.blocks, MakeBlock(bnd2, c39));
AddArraySlot(pageList.pages, page);

// Page 19
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c40));
AddArraySlot(page.blocks, MakeBlock(bnd2, c41));
AddArraySlot(pageList.pages, page);

// Page 20
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c42));
AddArraySlot(page.blocks, MakeBlock(bnd2, c43));
AddArraySlot(pageList.pages, page);

// Page 21
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c45));
AddArraySlot(page.blocks, MakeBlock(bnd2, c46));
AddArraySlot(pageList.pages, page);

// Page 22
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c47));
AddArraySlot(page.blocks,
	{bounds: bnd2,
	item: c48,
	dataLen: 407});
AddArraySlot(pageList.pages, page);

// Page 23
page := MakePage(NBMDefault);
AddArraySlot(page.blocks, MakeBlock(bnd1, c49));
AddArraySlot(page.blocks, MakeBlock(bnd7, c50));
AddArraySlot(pageList.pages, page);

AddArraySlot(book.rendering, pageList);

// Browsers & Page Hints
b1 := {
	name: "Contents",  list: []
};


AddArraySlot(b1.list, {	// 0
	item: c1
});
AddArraySlot(b1.list, {	// 1
	level: 2,
	item: c2
});
AddArraySlot(b1.list, {	// 2
	level: 2,
	item: c4
});
AddArraySlot(b1.list, {	// 3
	level: 2,
	item: c6
});
AddArraySlot(b1.list, {	// 4
	level: 2,
	item: c8
});
AddArraySlot(b1.list, {	// 5
	item: c10
});
AddArraySlot(b1.list, {	// 6
	level: 2,
	item: c11
});
AddArraySlot(b1.list, {	// 7
	level: 2,
	item: c13
});
AddArraySlot(b1.list, {	// 8
	level: 2,
	item: c15
});
AddArraySlot(b1.list, {	// 9
	level: 2,
	item: c17
});
AddArraySlot(b1.list, {	// 10
	level: 2,
	item: c19
});
AddArraySlot(b1.list, {	// 11
	level: 2,
	item: c21
});
AddArraySlot(b1.list, {	// 12
	level: 2,
	item: c23
});
AddArraySlot(b1.list, {	// 13
	level: 2,
	item: c25
});
AddArraySlot(b1.list, {	// 14
	level: 2,
	item: c27
});
AddArraySlot(b1.list, {	// 15
	level: 2,
	item: c29
});
AddArraySlot(b1.list, {	// 16
	item: c31
});
AddArraySlot(b1.list, {	// 17
	level: 2,
	item: c32
});
AddArraySlot(b1.list, {	// 18
	level: 2,
	item: c34
});
AddArraySlot(b1.list, {	// 19
	level: 2,
	item: c36
});
AddArraySlot(b1.list, {	// 20
	level: 2,
	item: c38
});
AddArraySlot(b1.list, {	// 21
	level: 2,
	item: c40
});
AddArraySlot(b1.list, {	// 22
	level: 2,
	item: c42
});
AddArraySlot(b1.list, {	// 23
	item: c44
});
AddArraySlot(b1.list, {	// 24
	level: 2,
	item: c45
});
AddArraySlot(b1.list, {	// 25
	level: 2,
	item: c47
});
AddArraySlot(b1.list, {	// 26
	level: 2,
	item: c49
});
AddArraySlot(book.browsers, b1);

// Indices and Sub-Indices
